/*
    Name:           PlayGate Framework
    Version:        1.0.0.0
    Copyright:      Copyright  2008-2009 PlayGate by PsichiX. All rights reserved.
    Author:         PsichiX
    Description:    PlayGate - GML Security System Framework
    
    Uses:
    GMThreads.dll by Snake [http://gamebaseteam.eu]
    CodeCaroline.dll by PsichiX

    License:
    Allows modification and expansion of the source code stated in basic functions 
    (PlayGateStartUp, PlayGateProgress, PlayGateClosure) and adding new features.
    It's necessary to add information on the use of the PlayGate system (and GMThreads.dll) in 
    GameMaker application. It's forbidden to call self as an author PlayGate system,
    or not provide information about that we use PlayGate system.

    Built-in functions:
    
    void Wait(bool statement,int time)                                          | Wait while given statement is true
    double C2D(char* value)                                                     | Convert Char* to double
    char* D2C(char* buff,double value,int length)                               | Convert double to char*
    char* MergeChar(char* buff,int count,...)                                   | Merge strings

    PlayGate object functions:

    double PlayGate.Initiation(double handle);                                  | Initiation
    double PlayGate.Execute(int priority,bool suspended,string code);           | Execute GML code
    double PlayGate.ExecuteResult(int priority,string code);                    | Execute GML code and wait for results
    double PlayGate.ExecuteSuspend(double thread)                               | Suspend executed code
    double PlayGate.ExecuteResume(double thread)                                | Resume suspended code
    double PlayGate.GetResultDouble(void);                                      | Get double value from results list
    string PlayGate.GetResultString(void);                                      | Get string value from results list
    double PlayGate.ResultCount(bool type);                                     | Return results list size
    double PlayGate.ResultClear(bool type);                                     | Clear results list
*/

#include "PlayGate.h"

#define exportdll extern "C" __declspec(dllexport)

using namespace std;

/* Here you put declaration code */
/* Begin */
   //...
/* End */


exportdll double PlayGateStartUp(double hwnd) // PlayGate startup function
{
/*        DO NOT CHANGE!  BEGIN          */
GMLThreadLoadLibrary("GMThreads.dll");
PlayGate.Initiation(hwnd);
/*        DO NOT CHANGE!  END            */

/* Here you put the code (GML/C++) executed at startup of application */
/* Begin */
   //...
/* End */
}

exportdll double PlayGateProgress(void) // PlayGate main function
{
/* Here you put the code (GML/C++) implemented in each call this function */
/* Begin */
   //...
/* End */
}

exportdll double PlayGateClosure(void) // PlayGate closure function
{
/* Here you put the code (GML/C++) executed at the close of application */
/* Begin */
   //...
/* End */

/*        DO NOT CHANGE!  BEGIN          */
Wait((bool)PlayGate.CheckAllThreads(),1);
GMLThreadFreeLibrary();
/*        DO NOT CHANGE!  END            */
}
